/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.Utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String objectToJson(Object object) {
        if (object != null) {
            try {
                String jsonData = MAPPER.writeValueAsString(object);
                return jsonData;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <T> T jsonToObject(String jsonData, Class<T> clazz) {
        if (StringUtils.isNotBlank((CharSequence)jsonData)) {
            try {
                Object t = MAPPER.readValue(jsonData, clazz);
                return (T)t;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <T> List<T> jsonToList(String jsonData, Class<T> clazz) {
        if (StringUtils.isNotBlank((CharSequence)jsonData)) {
            try {
                List list = (List)MAPPER.readValue(jsonData, (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, clazz));
                return list;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

