/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.service.impl;

import com.itheima.bean.Item;
import com.itheima.bean.TaoResult;
import com.itheima.service.Impls.SearchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.annotation.Autowired;

@Service
public class SearchServiceImpl
implements SearchService {
    @Autowired
    private SolrClient solrClient;

    public TaoResult<Item> search(String query, int page, int rows) {
        SolrQuery solrQuery = new SolrQuery();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            solrQuery.setQuery("item_title:" + query + " AND item_status:1");
        } else {
            solrQuery.setQuery("item_status:1");
        }
        solrQuery.setStart(Integer.valueOf((page - 1) * rows));
        solrQuery.setRows(Integer.valueOf(rows));
        solrQuery.setHighlight(true);
        solrQuery.addHighlightField("item_title");
        solrQuery.setHighlightSimplePre("<font color='red'>");
        solrQuery.setHighlightSimplePost("</font>");
        TaoResult taoResult = new TaoResult();
        try {
            QueryResponse response = this.solrClient.query((SolrParams)solrQuery);
            SolrDocumentList results = response.getResults();
            Map map = response.getHighlighting();
            ArrayList<Item> list = new ArrayList<Item>();
            for (SolrDocument solrDocument : results) {
                Item item = new Item();
                item.setId(Long.valueOf(Long.parseLong(solrDocument.get((Object)"id").toString())));
                List hlist = (List)((Map)map.get(solrDocument.get((Object)"id").toString())).get("item_title");
                if (hlist != null && hlist.size() > 0) {
                    item.setTitle((String)hlist.get(0));
                } else {
                    item.setTitle(solrDocument.get((Object)"item_title").toString());
                }
                item.setImage(solrDocument.get((Object)"item_image").toString());
                item.setPrice(Long.valueOf(Long.parseLong(solrDocument.get((Object)"item_price").toString())));
                item.setCid(Long.valueOf(Long.parseLong(solrDocument.get((Object)"item_cid").toString())));
                list.add(item);
            }
            taoResult.setRows(list);
            taoResult.setTotal(results.getNumFound());
            return taoResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return taoResult;
        }
    }
}

