/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.service.impl;

import com.itheima.bean.Item;
import com.itheima.mapper.ItemMapper;
import java.io.IOException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

@Component
public class ReceiveMessage {
    @Autowired
    private ItemMapper itemMapper;
    @Autowired
    private SolrClient solrClient;

    @JmsListener(destination="item")
    public void receiveAddItemMessage(String itemId) {
        Item item = (Item)this.itemMapper.selectByPrimaryKey((Object)Long.parseLong(itemId));
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        document.setField("id", (Object)item.getId().toString());
        document.setField("item_title", (Object)item.getTitle());
        document.setField("item_price", (Object)item.getPrice());
        document.setField("item_image", (Object)item.getImage());
        document.setField("item_cid", (Object)item.getCid());
        document.setField("item_status", (Object)item.getStatus());
        try {
            this.solrClient.add(document);
            this.solrClient.commit();
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

