/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONSerializer;
import net.sf.json.JSONString;
import net.sf.json.regexp.RegexpUtils;
import net.sf.json.util.JSONDynaBean;
import net.sf.json.util.JSONTokener;
import net.sf.json.util.JSONUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JSONObject
implements JSON {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$json$JSONObject == null ? (class$net$sf$json$JSONObject = JSONObject.class$("net.sf.json.JSONObject")) : class$net$sf$json$JSONObject));
    private boolean nullObject;
    private Map properties;
    static /* synthetic */ Class class$net$sf$json$JSONObject;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$net$sf$json$JSONFunction;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Number;

    public static JSONObject fromBean(Object bean) {
        if (bean == null || JSONUtils.isNull(bean)) {
            return new JSONObject(true);
        }
        if (bean instanceof JSONObject) {
            return new JSONObject((JSONObject)bean);
        }
        if (bean instanceof DynaBean) {
            return JSONObject.fromDynaBean((DynaBean)bean);
        }
        if (bean instanceof JSONTokener) {
            return JSONObject.fromJSONTokener((JSONTokener)bean);
        }
        if (bean instanceof JSONString) {
            return JSONObject.fromJSONString((JSONString)bean);
        }
        if (bean instanceof Map) {
            return JSONObject.fromMap((Map)bean);
        }
        if (bean instanceof String) {
            return JSONObject.fromString((String)bean);
        }
        if (JSONUtils.isNumber(bean) || JSONUtils.isBoolean(bean) || JSONUtils.isString(bean)) {
            return new JSONObject();
        }
        if (JSONUtils.isArray(bean)) {
            throw new IllegalArgumentException("'bean' is an array. Use JSONArray instead");
        }
        JSONObject jsonObject = new JSONObject();
        try {
            PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)bean);
            for (int i = 0; i < pds.length; ++i) {
                String key = pds[i].getName();
                if ("class".equals(key)) continue;
                Class<?> type = pds[i].getPropertyType();
                Object value = PropertyUtils.getProperty((Object)bean, (String)key);
                JSONObject.setValue(jsonObject, key, value, type);
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return jsonObject;
    }

    public static JSONObject fromDynaBean(DynaBean bean) {
        return new JSONObject(bean);
    }

    public static JSONObject fromJSONString(JSONString string) {
        return new JSONObject(new JSONTokener(string.toJSONString()));
    }

    public static JSONObject fromJSONTokener(JSONTokener tokener) {
        return new JSONObject(tokener);
    }

    public static JSONObject fromMap(Map map) {
        return new JSONObject(map);
    }

    public static JSONObject fromObject(Object object) {
        if (object == null || JSONUtils.isNull(object)) {
            return new JSONObject(true);
        }
        if (object instanceof JSONObject) {
            return new JSONObject((JSONObject)object);
        }
        if (object instanceof DynaBean) {
            return JSONObject.fromDynaBean((DynaBean)object);
        }
        if (object instanceof JSONTokener) {
            return JSONObject.fromJSONTokener((JSONTokener)object);
        }
        if (object instanceof JSONString) {
            return JSONObject.fromJSONString((JSONString)object);
        }
        if (object instanceof Map) {
            return JSONObject.fromMap((Map)object);
        }
        if (object instanceof String) {
            return JSONObject.fromString((String)object);
        }
        if (JSONUtils.isNumber(object) || JSONUtils.isBoolean(object) || JSONUtils.isString(object)) {
            return new JSONObject();
        }
        if (JSONUtils.isArray(object)) {
            throw new IllegalArgumentException("'bean' is an array. Use JSONArray instead");
        }
        return JSONObject.fromBean(object);
    }

    public static JSONObject fromString(String str) {
        if (str == null || "null".compareToIgnoreCase(str) == 0) {
            return new JSONObject(true);
        }
        return new JSONObject(str);
    }

    public static Object toBean(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        JSONDynaBean dynaBean = null;
        try {
            Map props = JSONUtils.getProperties(jsonObject);
            dynaBean = JSONUtils.newDynaBean(jsonObject);
            Iterator entries = props.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String key = (String)entry.getKey();
                Class type = (Class)entry.getValue();
                Object value = jsonObject.get(key);
                if (!JSONUtils.isNull(value)) {
                    if (value instanceof JSONArray) {
                        JSONObject.setProperty(dynaBean, key, JSONArray.toList((JSONArray)value));
                        continue;
                    }
                    if ((class$java$lang$String == null ? JSONObject.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(type) || (class$java$lang$Boolean == null ? JSONObject.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(type) || (class$java$lang$Byte == null ? JSONObject.class$("java.lang.Byte") : class$java$lang$Byte).isAssignableFrom(type) || (class$java$lang$Short == null ? JSONObject.class$("java.lang.Short") : class$java$lang$Short).isAssignableFrom(type) || (class$java$lang$Integer == null ? JSONObject.class$("java.lang.Integer") : class$java$lang$Integer).isAssignableFrom(type) || (class$java$lang$Long == null ? JSONObject.class$("java.lang.Long") : class$java$lang$Long).isAssignableFrom(type) || (class$java$lang$Float == null ? JSONObject.class$("java.lang.Float") : class$java$lang$Float).isAssignableFrom(type) || (class$java$lang$Double == null ? JSONObject.class$("java.lang.Double") : class$java$lang$Double).isAssignableFrom(type) || (class$java$lang$Character == null ? JSONObject.class$("java.lang.Character") : class$java$lang$Character).isAssignableFrom(type) || (class$net$sf$json$JSONFunction == null ? JSONObject.class$("net.sf.json.JSONFunction") : class$net$sf$json$JSONFunction).isAssignableFrom(type)) {
                        JSONObject.setProperty(dynaBean, key, value);
                        continue;
                    }
                    JSONObject.setProperty(dynaBean, key, JSONObject.toBean((JSONObject)value));
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn((Object)("Tried to assign null value to " + key + ":" + type.getName()));
                    JSONObject.setProperty(dynaBean, key, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                JSONObject.setProperty(dynaBean, key, null);
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return dynaBean;
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass) {
        return JSONObject.toBean(jsonObject, beanClass, null);
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass, Map classMap) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        if (beanClass == null) {
            return JSONObject.toBean(jsonObject);
        }
        if (classMap == null) {
            classMap = Collections.EMPTY_MAP;
        }
        HashMap bean = null;
        try {
            if (beanClass.isInterface()) {
                if (!(class$java$util$Map == null ? (class$java$util$Map = JSONObject.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(beanClass)) {
                    throw new IllegalArgumentException("beanClass is an interface. " + beanClass);
                }
                bean = new HashMap();
            } else {
                bean = (HashMap)beanClass.newInstance();
            }
            Map props = JSONUtils.getProperties(jsonObject);
            Iterator entries = props.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String key = (String)entry.getKey();
                Class type = (Class)entry.getValue();
                Object value = jsonObject.get(key);
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(bean, (String)key);
                if (!JSONUtils.isNull(value)) {
                    if (value instanceof JSONArray) {
                        if ((class$java$util$List == null ? JSONObject.class$("java.util.List") : class$java$util$List).isAssignableFrom(pd.getPropertyType())) {
                            List list = JSONArray.toList((JSONArray)value, beanClass, classMap);
                            JSONObject.setProperty(bean, key, list);
                            continue;
                        }
                        Object array = JSONArray.toArray((JSONArray)value, beanClass, classMap);
                        Class innerType = JSONUtils.getInnerComponentType(pd.getPropertyType());
                        if (innerType.isPrimitive() || (class$java$lang$Number == null ? JSONObject.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(innerType) || (class$java$lang$Boolean == null ? JSONObject.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(innerType) || (class$java$lang$Character == null ? JSONObject.class$("java.lang.Character") : class$java$lang$Character).isAssignableFrom(innerType) || !array.getClass().equals(pd.getPropertyType())) {
                            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
                        }
                        JSONObject.setProperty(bean, key, array);
                        continue;
                    }
                    if ((class$java$lang$String == null ? JSONObject.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(type) || (class$java$lang$Boolean == null ? JSONObject.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(type) || (class$java$lang$Byte == null ? JSONObject.class$("java.lang.Byte") : class$java$lang$Byte).isAssignableFrom(type) || (class$java$lang$Short == null ? JSONObject.class$("java.lang.Short") : class$java$lang$Short).isAssignableFrom(type) || (class$java$lang$Integer == null ? JSONObject.class$("java.lang.Integer") : class$java$lang$Integer).isAssignableFrom(type) || (class$java$lang$Long == null ? JSONObject.class$("java.lang.Long") : class$java$lang$Long).isAssignableFrom(type) || (class$java$lang$Float == null ? JSONObject.class$("java.lang.Float") : class$java$lang$Float).isAssignableFrom(type) || (class$java$lang$Double == null ? JSONObject.class$("java.lang.Double") : class$java$lang$Double).isAssignableFrom(type) || (class$java$lang$Character == null ? JSONObject.class$("java.lang.Character") : class$java$lang$Character).isAssignableFrom(type) || (class$net$sf$json$JSONFunction == null ? JSONObject.class$("net.sf.json.JSONFunction") : class$net$sf$json$JSONFunction).isAssignableFrom(type)) {
                        if (pd != null) {
                            if (!pd.getPropertyType().isInstance(value)) {
                                JSONObject.setProperty(bean, key, JSONUtils.getMorpherRegistry().morph(pd.getPropertyType(), value));
                                continue;
                            }
                            JSONObject.setProperty(bean, key, value);
                            continue;
                        }
                        JSONObject.setProperty(bean, key, value);
                        continue;
                    }
                    if (pd != null) {
                        JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value, pd.getPropertyType(), classMap));
                        continue;
                    }
                    Class targetClass = JSONObject.findTargetClass(key, classMap);
                    if (targetClass != null) {
                        JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value, targetClass, classMap));
                        continue;
                    }
                    JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value));
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn((Object)("Tried to assign null value to " + key + ":" + type.getName()));
                    JSONObject.setProperty(bean, key, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                JSONObject.setProperty(bean, key, null);
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return bean;
    }

    private static Class findTargetClass(String key, Map classMap) {
        Class targetClass = (Class)classMap.get(key);
        if (targetClass == null) {
            Iterator i = classMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!RegexpUtils.getMatcher((String)entry.getKey()).matches(key)) continue;
                targetClass = (Class)entry.getValue();
                break;
            }
        }
        return targetClass;
    }

    private static void setProperty(Object bean, String key, Object value) throws Exception {
        if (bean instanceof Map) {
            ((Map)bean).put(key, value);
        } else if (bean instanceof JSONObject) {
            if (!((JSONObject)bean).isNullObject()) {
                ((JSONObject)bean).set(key, value);
            }
        } else {
            PropertyUtils.setProperty((Object)bean, (String)key, (Object)value);
        }
    }

    private static void setValue(Object object, String key, Object value, Class type) {
        if (key == null) {
            throw new JSONException("Null key");
        }
        try {
            if (JSONUtils.isFunction(value)) {
                JSONObject.setProperty(object, key, value);
            } else if (value instanceof JSONString) {
                JSONObject.setProperty(object, key, JSONSerializer.toJSON((Object)((JSONString)value)));
            } else if (JSONUtils.isArray(value)) {
                JSONObject.setProperty(object, key, JSONArray.fromObject(value));
            } else if (value instanceof JSON) {
                JSONObject.setProperty(object, key, value);
            } else if ((class$java$lang$String == null ? (class$java$lang$String = JSONObject.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type) || value instanceof String) {
                String str = (String)value;
                if (str == null) {
                    JSONObject.setProperty(object, key, "");
                } else if (JSONUtils.mayBeJSON(str)) {
                    JSONObject.setProperty(object, key, JSONSerializer.toJSON((Object)str));
                } else {
                    JSONObject.setProperty(object, key, str);
                }
            } else if (JSONUtils.isNumber(value)) {
                JSONUtils.testValidity(value);
                JSONObject.setProperty(object, key, value);
            } else if (JSONUtils.isBoolean(value)) {
                JSONObject.setProperty(object, key, value);
            } else if (value == null) {
                if (JSONUtils.isArray(type)) {
                    JSONObject.setProperty(object, key, JSONSerializer.toJSON((Object)"[]"));
                } else if (JSONUtils.isNumber(type)) {
                    if (JSONUtils.isDouble(type)) {
                        JSONObject.setProperty(object, key, new Double(0.0));
                    } else {
                        JSONObject.setProperty(object, key, new Integer(0));
                    }
                } else if (JSONUtils.isBoolean(type)) {
                    JSONObject.setProperty(object, key, "false");
                } else if (JSONUtils.isString(type)) {
                    JSONObject.setProperty(object, key, "");
                } else {
                    JSONObject.setProperty(object, key, JSONNull.getInstance());
                }
            } else {
                System.err.println(value.getClass() + " " + value);
                JSONObject.setProperty(object, key, JSONObject.fromObject(value));
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    public JSONObject() {
        this.properties = new HashMap();
    }

    public JSONObject(boolean isNull) {
        this();
        this.nullObject = isNull;
    }

    public JSONObject(DynaBean bean) {
        this();
        if (bean == null) {
            this.nullObject = true;
            return;
        }
        DynaProperty[] props = bean.getDynaClass().getDynaProperties();
        for (int i = 0; i < props.length; ++i) {
            DynaProperty dynaProperty = props[i];
            String key = dynaProperty.getName();
            Class type = dynaProperty.getType();
            Object value = bean.get(dynaProperty.getName());
            JSONObject.setValue(this, key, value, type);
        }
    }

    public JSONObject(JSONObject jo) {
        this();
        if (jo == null || jo.isNullObject()) {
            this.nullObject = true;
            return;
        }
        JSONArray sa = jo.names();
        Iterator i = sa.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.putOpt(key, jo.opt(key));
        }
    }

    public JSONObject(JSONObject jo, String[] sa) {
        this();
        if (jo == null || jo.isNullObject()) {
            this.nullObject = true;
            return;
        }
        for (int i = 0; i < sa.length; ++i) {
            this.putOpt(sa[i], jo.opt(sa[i]));
        }
    }

    public JSONObject(JSONTokener x) {
        this();
        if (x.matches("null.*")) {
            this.nullObject = true;
            return;
        }
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            Object v;
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            if (!JSONUtils.isFunctionHeader(v = x.nextValue())) {
                this.set(key, v);
            } else {
                char ch;
                String params = JSONUtils.getFunctionParams((String)v);
                int i = 0;
                StringBuffer sb = new StringBuffer();
                while ((ch = x.next()) != '\u0000') {
                    if (ch == '{') {
                        ++i;
                    }
                    if (ch == '}') {
                        --i;
                    }
                    sb.append(ch);
                    if (i != 0) continue;
                    break;
                }
                if (i != 0) {
                    throw x.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                }
                String text = sb.toString();
                text = text.substring(1, text.length() - 1).trim();
                this.set(key, new JSONFunction(params != null ? params.split(",") : null, text));
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map map) {
        if (map == null) {
            this.nullObject = true;
            return;
        }
        this.properties = new HashMap();
        Iterator entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object k = entry.getKey();
            String key = k instanceof String ? (String)k : String.valueOf(k);
            Object value = entry.getValue();
            this.set(key, value);
        }
    }

    public JSONObject(Object object, String[] names) {
        this();
        if (object == null) {
            this.nullObject = true;
            return;
        }
        if (!(object instanceof DynaBean)) {
            try {
                PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)object);
                for (int i = 0; i < pds.length; ++i) {
                    String key = pds[i].getName();
                    if ("class".equals(key) || !ArrayUtils.contains((Object[])names, (Object)key)) continue;
                    Class<?> type = pds[i].getPropertyType();
                    Object value = PropertyUtils.getProperty((Object)object, (String)key);
                    JSONObject.setValue(this, key, value, type);
                }
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        } else {
            DynaBean bean = (DynaBean)object;
            DynaProperty[] props = bean.getDynaClass().getDynaProperties();
            for (int i = 0; i < props.length; ++i) {
                DynaProperty dynaProperty = props[i];
                String key = dynaProperty.getName();
                if (!ArrayUtils.contains((Object[])names, (Object)key)) continue;
                Class type = dynaProperty.getType();
                Object value = bean.get(dynaProperty.getName());
                JSONObject.setValue(this, key, value, type);
            }
        }
    }

    public JSONObject(String string) {
        this(new JSONTokener(string));
    }

    public JSONObject accumulate(String key, Object value) {
        if (this.isNullObject()) {
            throw new JSONException("Can't accumulate on null object");
        }
        JSONUtils.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value);
        } else if (o instanceof JSONArray) {
            ((JSONArray)o).put(value);
        } else {
            this.put(key, new JSONArray().put(o).put(value));
        }
        return this;
    }

    public Object get(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        if (o == null) {
            throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public JSONArray getJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
    }

    public String getString(String key) {
        this.verifyIsNull();
        return this.get(key).toString();
    }

    public boolean has(String key) {
        this.verifyIsNull();
        return this.properties.containsKey(key);
    }

    public boolean isArray() {
        return false;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean isNullObject() {
        return this.nullObject;
    }

    public Iterator keys() {
        this.verifyIsNull();
        return this.properties.keySet().iterator();
    }

    public int length() {
        this.verifyIsNull();
        return this.properties.size();
    }

    public JSONArray names() {
        this.verifyIsNull();
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja;
    }

    public Object opt(String key) {
        this.verifyIsNull();
        return key == null ? null : this.properties.get(key);
    }

    public boolean optBoolean(String key) {
        this.verifyIsNull();
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        this.verifyIsNull();
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        this.verifyIsNull();
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        this.verifyIsNull();
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : new Double((String)o).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        this.verifyIsNull();
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        this.verifyIsNull();
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        this.verifyIsNull();
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        this.verifyIsNull();
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        this.verifyIsNull();
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONObject put(String key, boolean value) {
        this.verifyIsNull();
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key, Collection value) {
        this.verifyIsNull();
        this.put(key, JSONArray.fromObject(value));
        return this;
    }

    public JSONObject put(String key, double value) {
        this.verifyIsNull();
        Double d = new Double(value);
        JSONUtils.testValidity(d);
        this.put(key, d);
        return this;
    }

    public JSONObject put(String key, int value) {
        this.verifyIsNull();
        this.put(key, new Integer(value));
        return this;
    }

    public JSONObject put(String key, long value) {
        this.verifyIsNull();
        this.put(key, new Long(value));
        return this;
    }

    public JSONObject put(String key, Map value) {
        this.verifyIsNull();
        this.put(key, JSONObject.fromObject(value));
        return this;
    }

    public JSONObject put(String key, Object value) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            this.set(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) {
        this.verifyIsNull();
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public Object remove(String key) {
        this.verifyIsNull();
        return this.properties.remove(key);
    }

    public JSONObject set(String key, Object value) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (JSONUtils.isFunction(value)) {
            this.properties.put(key, value);
        } else if (value instanceof JSONString) {
            this.properties.put(key, JSONSerializer.toJSON((Object)((JSONString)value)));
        } else if (JSONUtils.isArray(value)) {
            this.properties.put(key, JSONArray.fromObject(value));
        } else if (value instanceof JSON) {
            this.properties.put(key, value);
        } else if (JSONUtils.isString(value)) {
            String str = String.valueOf(value);
            if (JSONUtils.mayBeJSON(str)) {
                this.properties.put(key, JSONSerializer.toJSON((Object)str));
            } else {
                this.properties.put(key, str);
            }
        } else if (JSONUtils.isNumber(value)) {
            JSONUtils.testValidity(value);
            this.properties.put(key, JSONUtils.transformNumber((Number)value));
        } else if (JSONUtils.isBoolean(value)) {
            this.properties.put(key, value);
        } else {
            this.properties.put(key, JSONObject.fromObject(value));
        }
        return this;
    }

    public JSONArray toJSONArray(JSONArray names) {
        this.verifyIsNull();
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(':');
                sb.append(JSONUtils.valueToString(this.properties.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        return this.toString(indentFactor, 0);
    }

    public String toString(int indentFactor, int indent) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Iterator keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.next();
            sb.append(JSONUtils.quote(o.toString()));
            sb.append(": ");
            sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                Object o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(": ");
                sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public Writer write(Writer writer) {
        try {
            if (this.isNullObject()) {
                writer.write(JSONNull.getInstance().toString());
                return writer;
            }
            boolean b = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                Object k = keys.next();
                writer.write(JSONUtils.quote(k.toString()));
                writer.write(58);
                Object v = this.properties.get(k);
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONUtils.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private void verifyIsNull() {
        if (this.isNullObject()) {
            throw new JSONException("null object");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

