/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.ant;

import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.ant.ResultFormatter;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;
import com.googlecode.jslint4java.formatter.PlainFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class PlainResultFormatter
implements ResultFormatter {
    protected OutputStream out;
    protected PrintWriter w = null;
    private final JSLintResultFormatter form = new PlainFormatter();

    public void begin() {
        this.w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.out)));
    }

    public void end() {
        FileUtils.close((Writer)this.w);
        this.w = null;
    }

    public void output(JSLintResult result) {
        if (result.getIssues().size() == 0) {
            return;
        }
        this.w.print(this.form.format(result));
    }

    public void setFile(File file) {
        try {
            this.out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setStdout(OutputStream defaultOutputStream) {
        this.out = defaultOutputStream;
    }
}

