/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.ant;

import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.ant.ResultFormatter;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;
import com.googlecode.jslint4java.formatter.JUnitXmlFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class JUnitXmlResultFormatter
implements ResultFormatter {
    private File file;
    private final JSLintResultFormatter form = new JUnitXmlFormatter();

    public void begin() {
        if (this.file == null) {
            throw new BuildException("must set destFile attribute");
        }
        if (this.file.exists()) {
            if (!this.file.isDirectory()) {
                throw new BuildException(this.file + " must be a directory");
            }
        } else if (!this.file.mkdirs()) {
            throw new BuildException("failed to make directory " + this.file);
        }
    }

    public void end() {
        this.file = null;
    }

    public void output(JSLintResult result) {
        File f = new File(this.file, this.testFileName(result));
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            w.write(this.form.format(result));
        }
        catch (IOException e) {
            try {
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.close(w);
                throw throwable;
            }
        }
        FileUtils.close((Writer)w);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setStdout(OutputStream defaultOutputStream) {
    }

    private String testFileName(JSLintResult result) {
        return "TEST-" + result.getName().replaceAll("[^\\w.-]", "_") + ".xml";
    }
}

