/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.ant;

import com.googlecode.jslint4java.JSLint;
import com.googlecode.jslint4java.JSLintBuilder;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.Option;
import com.googlecode.jslint4java.ant.FormatterElement;
import com.googlecode.jslint4java.ant.PredefElement;
import com.googlecode.jslint4java.ant.ResultFormatter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;

public class JSLintTask
extends Task {
    private final Union resources = new Union();
    private final List<ResultFormatter> formatters = new ArrayList<ResultFormatter>();
    private boolean haltOnFailure = true;
    private String encoding = System.getProperty("file.encoding", "UTF-8");
    private String failureProperty = null;
    private File jslintSource = null;
    private final Map<Option, String> options = new HashMap<Option, String>();
    private PredefElement predef = null;

    public void add(ResourceCollection rc) {
        this.resources.add(rc);
    }

    public void addConfiguredFormatter(FormatterElement fe) {
        fe.setDefaultOutputStream(this.getDefaultOutput());
        this.formatters.add(fe.getResultFormatter());
    }

    public void addPredef(PredefElement predef) {
        this.predef = predef;
    }

    public void applyOptions(JSLint lint) {
        for (Map.Entry<Option, String> entry : this.options.entrySet()) {
            String value = entry.getValue();
            try {
                if (value == null) {
                    lint.addOption(entry.getKey());
                    continue;
                }
                lint.addOption(entry.getKey(), value);
            }
            catch (IllegalArgumentException e) {
                String optName = entry.getKey().getLowerName();
                String className = e.getClass().getName();
                throw new BuildException(optName + ": " + className + ": " + e.getMessage());
            }
        }
        if (this.predef != null) {
            lint.addOption(Option.PREDEF, this.predef.getText());
        }
    }

    public void execute() throws BuildException {
        if (this.resources.size() == 0) {
            throw new BuildException("no resources specified");
        }
        JSLint lint = this.makeLint();
        this.applyOptions(lint);
        for (ResultFormatter rf : this.formatters) {
            rf.begin();
        }
        int failedCount = 0;
        int totalErrorCount = 0;
        for (Resource resource : this.resources.listResources()) {
            try {
                int errorCount = this.lintStream(lint, resource);
                if (errorCount <= 0) continue;
                totalErrorCount += errorCount;
                ++failedCount;
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        for (ResultFormatter rf : this.formatters) {
            rf.end();
        }
        if (failedCount != 0) {
            String msg = this.failureMessage(failedCount, totalErrorCount);
            if (this.haltOnFailure) {
                throw new BuildException(msg);
            }
            this.log(msg);
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, msg);
            }
        }
    }

    private String failureMessage(int failedCount, int totalErrorCount) {
        return "JSLint: " + totalErrorCount + " " + this.plural(totalErrorCount, "error") + " in " + failedCount + " " + this.plural(failedCount, "file");
    }

    private OutputStream getDefaultOutput() {
        return new LogOutputStream((Task)this, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lintStream(JSLint lint, Resource resource) throws UnsupportedEncodingException, IOException {
        InputStream stream = null;
        try {
            stream = resource.getInputStream();
            String name = resource.toString();
            JSLintResult result = lint.lint(name, (Reader)new BufferedReader(new InputStreamReader(stream, this.encoding)));
            this.log("Found " + result.getIssues().size() + " issues in " + name, 3);
            for (ResultFormatter rf : this.formatters) {
                rf.output(result);
            }
            int n = result.getIssues().size();
            return n;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public JSLint makeLint() throws BuildException {
        try {
            if (this.jslintSource == null) {
                return new JSLintBuilder().fromDefault();
            }
            return new JSLintBuilder().fromFile(this.jslintSource);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String plural(int count, String word) {
        return count == 1 ? word : word + "s";
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void setJslint(File jslint) {
        this.jslintSource = jslint;
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    public void setOptions(String optionList) throws BuildException {
        for (String name : optionList.split("\\s*,\\s*")) {
            String[] parts = name.split("=", 2);
            String optName = parts[0];
            try {
                Option o = Option.valueOf((String)optName.toUpperCase(Locale.getDefault()));
                String value = parts.length == 2 ? parts[1] : null;
                this.options.put(o, value);
            }
            catch (IllegalArgumentException e) {
                throw new BuildException("Unknown option " + optName);
            }
        }
    }
}

