/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import java.util.concurrent.TimeUnit;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;

public class TimeLimitedContextFactory
extends ContextFactory {
    private static final int OPS_QUANTUM = 10000;
    private final long maxTimeNanos;

    public TimeLimitedContextFactory(long maxTime, TimeUnit timeUnit) {
        this.maxTimeNanos = timeUnit.toNanos(maxTime);
    }

    protected Context makeContext() {
        TimeLimitedContext cx = new TimeLimitedContext(this);
        cx.setInstructionObserverThreshold(10000);
        return cx;
    }

    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        TimeLimitedContext tlcx = (TimeLimitedContext)cx;
        tlcx.startTime = System.nanoTime();
        return super.doTopCall(callable, tlcx, scope, thisObj, args);
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
        TimeLimitedContext tlcx = (TimeLimitedContext)cx;
        long currentTime = System.nanoTime();
        long durationNanos = currentTime - tlcx.startTime;
        if (durationNanos > this.maxTimeNanos) {
            throw new TimeExceededException();
        }
    }

    private static class TimeLimitedContext
    extends Context {
        private long startTime;

        public TimeLimitedContext(TimeLimitedContextFactory timeLimitedContextFactory) {
            super(timeLimitedContextFactory);
        }
    }

    public static class TimeExceededException
    extends IllegalStateException {
    }
}

