package com.baidu.tangram;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * 为git扩展，获取当前项目父目录名称，用于daily build中支持用户信息<br>
 * 由于可能存在非用户使用模式，如果提取失败会直接使用空串
 * 
 * @author bell
 * 
 */
public class GitExt extends Task {
	public void execute() throws BuildException {
		String user = getGitUserInfo();
		File upath = getProject().getBaseDir().getParentFile(); 
		if (upath.getName().equals(user)) {
			// 尝试分析父路径是否用户名称，返回用户信息
			getProject().setProperty("git.user", user);
			System.out.println("set git.user as " + user);
		} else
			getProject().setProperty("git.user", "");
	}

	/**
	 * 从git的配置文件中读取用户信息
	 * 
	 * @return
	 */
	private String getGitUserInfo() {
		File gitconfig = new File(getProject().getBaseDir() + "/.git/config");
		String user = "BaiduFE";// 默认用户
		BufferedReader reader = null;
		if (gitconfig.exists()) {
			try {
				reader = new BufferedReader(new InputStreamReader(
						new FileInputStream(gitconfig)));
				while (reader.ready()) {
					String line = reader.readLine();
					Matcher m = Pattern.compile(
							"\\s+url = git[@:][/]{0,2}github\\.com[:/]([^/]+)/.*.git")
							.matcher(line);
					if (m.matches()) {
						user = m.group(1);
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				try {
					if (reader != null)
						reader.close();
				} catch (Exception e) {
				}
			}
		} else {
			System.out.println("config file not found : "
					+ gitconfig.getAbsolutePath());
		}
		return user;
	}
}
